import React from "react";
import { Form, Slider, Select, InputNumber, Switch, Alert, Button } from "antd";
import { layout, tailLayout } from "../unit";

const { Option } = Select;

export default function EncoderSetting({
  saveServerConfig,
  serverConfig,
  wsConnected,
}) {
  const [form] = Form.useForm();

  const onFinish = (values) => {
    saveServerConfig(values);
  };

  return (
    <div style={{ padding: "20px 0" }}>
      <Alert
        message="编码器设置"
        description="配置车速编码器参数，修改后需重启程序生效"
        type="info"
        showIcon
        style={{ marginBottom: "20px" }}
      />
      
      <Form
        {...layout}
        form={form}
        onFinish={onFinish}
        initialValues={{
          ...serverConfig,
          encoderEnabled: serverConfig.encoderEnabled ?? true,
          encoderBaudRate: serverConfig.encoderBaudRate ?? 115200,
          encoderPPR: serverConfig.encoderPPR ?? 100,
          encoderWheelDiameterMm: serverConfig.encoderWheelDiameterMm ?? 50.8,
          encoderIntervalMs: serverConfig.encoderIntervalMs ?? 1000,
          encoderSpeedUnit: serverConfig.encoderSpeedUnit ?? "km/h",
          encoderInvert: serverConfig.encoderInvert ?? false,
        }}
      >
        <Form.Item
          label="启用编码器"
          name="encoderEnabled"
          valuePropName="checked"
        >
          <Switch disabled={!wsConnected} />
        </Form.Item>



        <Form.Item
          label="波特率"
          name="encoderBaudRate"
          extra="Arduino串口通信波特率"
        >
          <Select disabled={!wsConnected}>
            <Option value={9600}>9600</Option>
            <Option value={19200}>19200</Option>
            <Option value={38400}>38400</Option>
            <Option value={57600}>57600</Option>
            <Option value={115200}>115200 (推荐)</Option>
            <Option value={230400}>230400</Option>
            <Option value={250000}>250000</Option>
          </Select>
        </Form.Item>

        <Form.Item
          label="每转脉冲数(PPR)"
          name="encoderPPR"
          extra="编码器每转产生的脉冲数"
        >
          <InputNumber
            disabled={!wsConnected}
            min={1}
            max={10000}
            style={{ width: "100%" }}
          />
        </Form.Item>

        <Form.Item
          label="车轮直径(mm)"
          name="encoderWheelDiameterMm"
          extra="车轮的直径(毫米)"
        >
          <InputNumber
            disabled={!wsConnected}
            min={1}
            max={2000}
            step={0.1}
            style={{ width: "100%" }}
          />
        </Form.Item>

        <Form.Item
          label="更新间隔(ms)"
          name="encoderIntervalMs"
          extra="编码器数据更新的时间间隔(毫秒)"
        >
          <InputNumber
            disabled={!wsConnected}
            min={50}
            max={5000}
            style={{ width: "100%" }}
          />
        </Form.Item>

        <Form.Item
          label="速度单位"
          name="encoderSpeedUnit"
          extra="显示速度的单位"
        >
          <Select disabled={!wsConnected}>
            <Option value="km/h">km/h (公里/小时)</Option>
            <Option value="m/s">m/s (米/秒)</Option>
            <Option value="mph">mph (英里/小时)</Option>
          </Select>
        </Form.Item>

        <Form.Item
          label="反转方向"
          name="encoderInvert"
          valuePropName="checked"
          extra="是否反转编码器方向"
        >
          <Switch disabled={!wsConnected} />
        </Form.Item>

        <Form.Item label=" " colon={false}>
          <div style={{ fontSize: "12px", color: "#888", lineHeight: "1.5", marginBottom: "16px" }}>
            <strong>注意：</strong><br/>
            • A相和B相引脚必须连接到编码器的对应输出<br/>
            • PPR值需与实际编码器规格匹配<br/>
            • 修改设置后需要重启程序才能生效
          </div>
          <Button type="primary" htmlType="submit" disabled={!wsConnected}>
            保存设置
          </Button>
        </Form.Item>
      </Form>
    </div>
  );
}