import React, { Component } from "react";
import store from "store";
import { Form, Button, Switch, Slider, Popover, Space } from "antd";
import {
  SlidersOutlined,
  DragOutlined,
  SoundOutlined,
  MoreOutlined,
  StopOutlined,
} from "@ant-design/icons";
import Keybord from "./Keyboard";
import Ai from "./Ai";
import { Router } from "@reach/router";
import ObjectDetection from "./ObjectDetection";
import ControlUI from "./ControlUI";
import Gamepad from "./Gamepad";

export default class Controller extends Component {
  constructor(props) {
    super(props);
    this.state = {
      zeroOrientation: undefined,
      isShowButton: store.get("is-show-button") || true,
    };
    this.steeringStatus = [];
  }

  onControl() {}

  fixContent = () => {
    const {
      serverConfig: { channelList = [], specialChannel = {} },
      saveServerConfig,
    } = this.props;

    const direction = channelList.find(
      ({ id }) => id === specialChannel.direction
    );

    return (
      <Form>
        {direction && (
          <Form.Item label="舵机微调">
            <Slider
              defaultValue={direction.valueReset * 50 + 50}
              min={0}
              max={100}
              included={false}
              onChange={(v) => {
                direction.valueReset = v / 50 - 1;
                saveServerConfig({
                  channelList,
                });
              }}
              style={{ width: "50vw" }}
            />
          </Form.Item>
        )}
      </Form>
    );
  };

  render() {
    const {
      fixContent,
      props: {
        action,
        cameraEnabled,
        videoEl,
        setting,
        playAudio,
        serverConfig,
        changeChannel,
        editabled,
        cameraList,
        channelStatus,
        saveServerConfig,
        isFullscreen,
        session,
        webrtcChannel,
      },
    } = this;
    const { isShowButton } = this.state;
    const { channelList = [], specialChannel = {} } = serverConfig;
    const speedChannel = channelList.find(
      ({ id }) => id === specialChannel.speed
    );
    const { audioList = [] } = serverConfig;
    const visibleAudioList = audioList.filter(({ type }) => type !== "text");

    return (
      <div className="controller">
        <Router className="controller-router">
          <Ai
            path="ai/learn/*"
            canvasRef={videoEl}
            cameraEnabled={cameraEnabled}
            action={action}
            onAi={(isAiControlling) => this.setState({ isAiControlling })}
          />
          <ObjectDetection
            path="ai/coco-ssd/*"
            videoEl={videoEl}
            cameraEnabled={cameraEnabled}
            action={action}
            onAi={(isAiControlling) => this.setState({ isAiControlling })}
          />
        </Router>
        {!isFullscreen && (
          <Form className="controller-form" size="small" layout="inline">
            <Form.Item>
              <Popover
                content={fixContent}
                title="修正"
                trigger="click"
                placement="topLeft"
              >
                <Button icon={<SlidersOutlined />}>修正</Button>
              </Popover>
            </Form.Item>
            {speedChannel && (
              <>
                <Form.Item>
                  <Popover
                    placement="topLeft"
                    content={
                      <Slider
                        defaultValue={speedChannel.valuePostive * 100}
                        min={0}
                        max={100}
                        onChange={(v) => {
                          speedChannel.valuePostive = v / 100;
                          saveServerConfig({
                            channelList,
                          });
                        }}
                        arrowPointAtCenter
                        style={{ width: "30vw" }}
                      />
                    }
                  >
                    <Button shape="round">
                      前进:{Math.round(speedChannel.valuePostive * 100)}
                    </Button>
                  </Popover>
                </Form.Item>
                <Form.Item>
                  <Popover
                    placement="topLeft"
                    content={
                      <Slider
                        defaultValue={speedChannel.valueNegative * -100}
                        min={0}
                        max={100}
                        style={{ width: "30vw" }}
                        onChange={(v) => {
                          speedChannel.valueNegative = (v / 100) * -1;
                          saveServerConfig({
                            channelList,
                          });
                        }}
                      />
                    }
                  >
                    <Button shape="round">
                      倒退:{Math.round(speedChannel.valueNegative * -100)}
                    </Button>
                  </Popover>
                </Form.Item>
              </>
            )}

            <Form.Item>
              <Gamepad
                changeChannel={changeChannel}
                channelList={serverConfig.channelList}
                channelStatus={channelStatus}
                playAudio={playAudio}
                serverConfig={serverConfig}
              />
            </Form.Item>

            <Form.Item>
            <Keybord
              playAudio={playAudio}
              channelStatus={channelStatus}
              channelList={serverConfig.channelList}
              changeChannel={changeChannel}
              serverConfig={serverConfig}
            />

            </Form.Item>
            {visibleAudioList
              .filter((i) => i.showFooter)
              .map(({ path, name, type }) => (
                <Form.Item key={name}>
                  <Button
                    shape="round"
                    onClick={() =>
                      playAudio(type === "stop" ? { stop: true } : { path })
                    }
                    icon={type === "stop" ? <StopOutlined /> : <SoundOutlined />}
                  >
                    {name}
                  </Button>
                </Form.Item>
              ))}

            <Form.Item>
              <Popover
                placement="topRight"
                content={
                  <Space size={[16, 16]} wrap>
                    <Form.Item extra="显示触控 UI">
                      <Switch
                        checked={isShowButton}
                        onChange={(isShowButton) => {
                          store.set("is-show-button", isShowButton);
                          this.setState({ isShowButton });
                        }}
                        checkedChildren={<DragOutlined />}
                        unCheckedChildren={<DragOutlined />}
                      />
                    </Form.Item>
                    {visibleAudioList
                      .filter((i) => !i.showFooter)
                      .map(({ path, name, type }) => (
                        <Form.Item extra={`播放${name}`} key={name}>
                          {type === "audio" && (
                            <Button
                              shape="round"
                              onClick={() => playAudio({ path })}
                              icon={<SoundOutlined />}
                            >
                              {name}
                            </Button>
                          )}
                          {type === "stop" && (
                            <Button
                              shape="round"
                              onClick={() => playAudio({ stop: true })}
                              icon={<StopOutlined />}
                            >
                              {name}
                            </Button>
                          )}
                        </Form.Item>
                      ))}
                  </Space>
                }
              >
                <Button shape="round">
                  <MoreOutlined />
                </Button>
              </Popover>
            </Form.Item>
          </Form>
        )}
        <ControlUI
          webrtcChannel={webrtcChannel}
          session={session}
          channelStatus={channelStatus}
          isShowButton={isShowButton}
          uiComponentList={serverConfig.uiComponentList}
          channelList={serverConfig.channelList}
          changeChannel={changeChannel}
          editabled={editabled}
          cameraList={cameraList}
          setting={setting}
          isFullscreen={isFullscreen}
          statusInfo={this.props.statusInfo}
        />
      </div>
    );
  }
}
