import React from "react";
import { Form, InputNumber, Switch, Select, Card, Typography, Space } from "antd";

const { Title } = Typography;
const { Option } = Select;

export default function EncoderSetting({ encoderConfig, onSaveEncoderConfig }) {
  const [form] = Form.useForm();

  const onFinish = (values) => {
    onSaveEncoderConfig(values);
  };

  return (
    <Card title="编码器设置">
      <Form
        form={form}
        layout="vertical"
        onFinish={onFinish}
        initialValues={encoderConfig}
      >
        <Form.Item name="enabled" label="启用编码器" valuePropName="checked">
          <Switch />
        </Form.Item>

        <Form.Item name="gpioAPin" label="GPIO A 引脚" initialValue={5}>
          <InputNumber min={0} max={40} disabled={true} /> {/* 固定值，不可修改 */}
        </Form.Item>

        <Form.Item name="gpioBPin" label="GPIO B 引脚" initialValue={6}>
          <InputNumber min={0} max={40} disabled={true} /> {/* 固定值，不可修改 */}
        </Form.Item>

        <Form.Item name="ppr" label="每转脉冲数 (PPR)">
          <InputNumber min={1} max={10000} />
        </Form.Item>

        <Form.Item name="mode" label="编码器模式">
          <Select>
            <Option value="x1">x1</Option>
            <Option value="x2">x2</Option>
            <Option value="x4">x4</Option>
          </Select>
        </Form.Item>

        <Form.Item name="intervalMs" label="更新间隔 (毫秒)">
          <InputNumber min={100} max={10000} />
        </Form.Item>

        <Form.Item name="wheelDiameterMm" label="轮子直径 (毫米)">
          <InputNumber min={10} max={1000} />
        </Form.Item>

        <Form.Item name="speedUnit" label="速度单位">
          <Select>
            <Option value="km/h">公里/小时 (km/h)</Option>
            <Option value="m/s">米/秒 (m/s)</Option>
            <Option value="mph">英里/小时 (mph)</Option>
          </Select>
        </Form.Item>

        <Form.Item name="speedLabel" label="车速显示标签">
          <Input placeholder="车速" />
        </Form.Item>

        <Form.Item name="rpmLabel" label="转速显示标签">
          <Input placeholder="转速" />
        </Form.Item>

        <Form.Item name="showRpm" label="显示转速" valuePropName="checked">
          <Switch />
        </Form.Item>

        <Form.Item name="showDirection" label="显示方向" valuePropName="checked">
          <Switch />
        </Form.Item>

        <Form.Item>
          <Space>
            <Form.Item noStyle>
              <Form.Button type="primary" htmlType="submit">
                保存编码器设置
              </Form.Button>
            </Form.Item>
          </Space>
        </Form.Item>
      </Form>
    </Card>
  );
}