import React from "react";
import { Space, Typography } from "antd";
import { HomeOutlined } from "@ant-design/icons";

const { Text } = Typography;

export default function Nav(props) {
  return (
    <Space
      align="center"
      size="large"
      style={{ width: "100%", justifyContent: "center", flexDirection: "column" }}
    >
      <a
        href="https://240318.xyz"
        target="_blank"
        rel="noopener noreferrer"
      >
        <HomeOutlined /> RaspiCar
      </a>
      <Text type="secondary" style={{ fontSize: "12px", textAlign: "center" }}>
        基于<a href="https://network-rc.esonwong.com/" target="_blank" rel="noopener noreferrer">Network RC</a>项目进行修改的 RC遥控车控制系统，进行重新适配及修改功能。
      </Text>
    </Space>
  );
}
