"""
简化版配置文件 - 仅保留USB摄像头和电调舵机控制
"""
import os

# 路径
CAR_PATH = PACKAGE_PATH = os.path.dirname(os.path.realpath(__file__))
DATA_PATH = os.path.join(CAR_PATH, 'data')
MODELS_PATH = os.path.join(CAR_PATH, 'models')

# 摄像头设置 - USB摄像头
CAMERA_TYPE = "WEBCAM"
IMAGE_W = 160
IMAGE_H = 120
IMAGE_DEPTH = 3
CAMERA_FRAMERATE = 15
CAMERA_VFLIP = False
CAMERA_HFLIP = False
CAMERA_INDEX = 0

# 驱动系统设置
DRIVE_TRAIN_TYPE = "PWM_STEERING_THROTTLE"
PWM_STEERING_THROTTLE = {
    "PWM_STEERING_PIN": "RPI_GPIO.BCM.12",
    "PWM_STEERING_SCALE": 1.0,
    "PWM_STEERING_INVERTED": False,
    "PWM_THROTTLE_PIN": "RPI_GPIO.BCM.13",
    "PWM_THROTTLE_SCALE": 1.0,
    "PWM_THROTTLE_INVERTED": False,
    "STEERING_LEFT_PWM": 460,
    "STEERING_RIGHT_PWM": 290,
    "THROTTLE_FORWARD_PWM": 500,
    "THROTTLE_STOPPED_PWM": 370,
    "THROTTLE_REVERSE_PWM": 220,
}

# 车辆循环频率
DRIVE_LOOP_HZ = 20
MAX_LOOPS = None

# Web控制
WEB_CONTROL_PORT = 8887
WEB_INIT_MODE = "user"

# 日志
HAVE_CONSOLE_LOGGING = True
LOGGING_LEVEL = 'INFO'
LOGGING_FORMAT = '%(message)s'

# 关闭所有不需要的功能
USE_SSD1306_128_32 = False
USE_JOYSTICK_AS_DEFAULT = False
HAVE_ODOM = False
USE_LIDAR = False
HAVE_TFMINI = False
HAVE_IMU = False
HAVE_SOMBRERO = False
HAVE_RGB_LED = False
DONKEY_GYM = False
HAVE_MQTT_TELEMETRY = False
